/* 	Name       : 	client_udp_broadcast.c
	Author     : 	Luis A. Rivera
	Description: 	ECE 4220 lab, Spring 2012
					Lab 5. Simple client (UDP) for lecture purposes			*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include <fcntl.h>
#include <pthread.h>
#include <semaphore.h>
#include <ifaddrs.h>

#define MSG_SIZE 40			// message size



typedef struct str_purche	// data structure for fifo
{
    int m_id, qty;
} purchaseStr;

sem_t sem1,sem2;

int sock, n;
int transac_id;
unsigned int length;
struct sockaddr_in anybody, from;
//char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
int boolval = 1;			// for a socket option

int fd_fifo_in ,read_status; //variables for FIFO
purchaseStr fifobuffer;

int my_board;

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

void thtask(void *ptr){

	char buffer[MSG_SIZE];

	do
	  {


		//sem_wait(&sem1);

	   read_status = read(fd_fifo_in,&fifobuffer,sizeof(fifobuffer));
	   		if (read_status < 0){
	   				printf("FIFO read error\n");
	   				exit(1);
	   		}

	    transac_id++; //counting transaction ID

	   	sprintf(buffer, "# %d id %d ticket %d qty %d trns %d\n",my_board, fifobuffer.m_id,(rand() % 2) + 1, (rand() % 3) + 1, transac_id);
	   	//printf("received order from id %d, qty = %d\n",fifobuffer.m_id, fifobuffer.qty);
	   	//printf("%s", buffer);

	   //	sem_post(&sem1);

	   	sem_wait(&sem2); //grab semaphore

		   // send request to the server
		   n = sendto(sock, buffer, strlen(buffer), 0,
				      (const struct sockaddr *)&anybody,length);
		   if (n < 0)
			   error("Sendto");
		   printf("Sent: %s", buffer);

		   // receive message back
		   n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
		   if (n < 0)
			   error("recvfrom");
			   printf("Received: %s \n", buffer);

	   sem_post(&sem2); //releaes semaphore

	  } while (buffer[0] != '!'); //make it run forever

}

int main(int argc, char *argv[])
{

   pthread_t thread1, thread2, thread3;

   /*if (argc != 2)
   {
	   printf("usage: %s port\n", argv[0]);
       exit(1);
   }*/

   ///init semaphore
   sem_init(&sem1,0,1);
   sem_init(&sem2,0,1);

   transac_id = 0;

   /**********************Find my board number***********************/
     struct ifaddrs * ifAddrStruct=NULL;
     struct ifaddrs * ifa=NULL;
     void * tmpAddrPtr=NULL;
     char addressBuffer[INET_ADDRSTRLEN];
     char addressBuffer_tmp[INET_ADDRSTRLEN];

     char *boardno_s;

     getifaddrs(&ifAddrStruct);

     ifa = ifAddrStruct;
     ifa = ifa->ifa_next;
     if (ifa ->ifa_addr->sa_family==AF_INET) { // check it is IP4
         // is a valid IP4 Address
       tmpAddrPtr=&((struct sockaddr_in *)ifa->ifa_addr)->sin_addr;
       //char addressBuffer[INET_ADDRSTRLEN];
       inet_ntop(AF_INET, tmpAddrPtr, addressBuffer, INET_ADDRSTRLEN);
       printf("My IP is %s\n", addressBuffer);
       //IPaddress = addressBuffer;
     }


     strcpy(addressBuffer_tmp, addressBuffer);
     boardno_s = strtok(addressBuffer_tmp, ".");
     boardno_s = strtok(NULL, ".");
     boardno_s = strtok(NULL, ".");
     boardno_s = strtok(NULL, ".");
     my_board = atoi(boardno_s);
     printf("My board no. is %d\n", my_board);

     if (ifAddrStruct!=NULL) freeifaddrs(ifAddrStruct);

    /********************Create Socket***********************/

   sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
   if (sock < 0)
	   error("socket");

   // change socket permissions to allow broadcast
   if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
     	{
     		printf("error setting socket options\n");
     		exit(-1);
     	}

   anybody.sin_family = AF_INET;		// symbol constant for Internet domain
   //anybody.sin_port = htons(atoi(argv[1]));				// port field
   anybody.sin_port = htons(3000);  //using PORT 3000
   anybody.sin_addr.s_addr = inet_addr("10.3.52.255");	// broadcast address

   length = sizeof(struct sockaddr_in);		// size of structure

	/////////// Initialize FIFO //////////

	fd_fifo_in = open("/dev/rtf/0",O_RDWR);
	if (fd_fifo_in < 0){
		printf("can't open FIFO\n");
		exit(1);
	}
	//////////////////////////////////////////


	/////////////////create threads///////////////////
	pthread_create(&thread1, NULL, (void *)&thtask, NULL);
	pthread_create(&thread2, NULL, (void *)&thtask, NULL);
	pthread_create(&thread3, NULL, (void *)&thtask, NULL);

	pthread_join(thread1, NULL);
	pthread_join(thread2, NULL);
	pthread_join(thread3, NULL);

////NEVER GET TO THIS POINT///
   close(sock);						// close socket.
   return 0;
}
